////////////////////////////////////////////////////////////
// Fix for a bug in the hom construction
if not assigned _HOM then
  "Loading a fix for a bug with the hom constructor";

  function HOM(X, Y)
    F := Parent(Y[1][1]);
    n := #Generators(F);
    gens := [F.i : i in [1..n]];
    Y := [ <Index(gens, Y[i][1]), Y[i][2]> : i in [1..#Y] ];
    Sort(~Y, func<x,y|x[1]-y[1]>);

    assert [1..n] eq [Y[i][1] : i in [1..#Y]]; 

    return hom< X[1] -> X[2] | [Y[i][2] : i in [1..#Y]] >;
  end function;

  _HOM := "loaded";
end if;

////////////////////////////////////////////////////////////
// Example of the bug
/*
F := SLPGroup(3);
G := SLPGroup(3);

// this works
hom< F -> G | [ G.1, G.2, G.3 ] >;

// this doesn't
//hom< F -> G | [ F.3 -> G.3, F.1 -> G.1, F.2 -> G.2] >;

// this does
HOM( F -> G, [ F.3 -> G.3, F.1 -> G.1, F.2 -> G.2] );
*/








